#include<stdio.h>

enum KRV
{
	KRV_O = 0,
	KRV_A = 1,
	KRV_B = 2,
	KRV_AB = 3
};

struct pacijent
{
	KRV grupa;
	int potrebna_krv;
	int izvor_krvi[4];
};

//Ukoliko nema dovoljno krvi u zalihama, vrati FALSE
bool uzmi_krv(pacijent& p, KRV grupa, int* zalihe)
{
	if (zalihe[grupa] >= p.potrebna_krv)
	{
		p.izvor_krvi[grupa] = p.potrebna_krv;
		zalihe[grupa] -= p.potrebna_krv;
		p.potrebna_krv = 0;
		return true;
	}
	else
	{
		p.izvor_krvi[grupa] = zalihe[grupa];
		p.potrebna_krv -= zalihe[grupa];
		zalihe[grupa] = 0;
		return false;
	}
}

int main()
{
	pacijent pacijenti[1000];
	int br_pacijenata;

	int zalihe[4];

	scanf("%d", &br_pacijenata);
	scanf("%d%d%d%d%*c", &zalihe[KRV_O], &zalihe[KRV_A], &zalihe[KRV_B], &zalihe[KRV_AB]);

	for (int i = 0; i < br_pacijenata; i++)
	{
		pacijenti[i].izvor_krvi[KRV_O] = 0;
		pacijenti[i].izvor_krvi[KRV_A] = 0;
		pacijenti[i].izvor_krvi[KRV_B] = 0;
		pacijenti[i].izvor_krvi[KRV_AB] = 0;

		char c1, c2;
		scanf("%c%c", &c1, &c2);
		
		if (c2 == 'B')
			pacijenti[i].grupa = KRV_AB;
		else if (c1 == 'O')
			pacijenti[i].grupa = KRV_O;
		else if (c1 == 'A')
			pacijenti[i].grupa = KRV_A;
		else
			pacijenti[i].grupa = KRV_B;

		scanf("%d%*c", &pacijenti[i].potrebna_krv);
	}
	
	bool nemoguce = false;
	
	//Pacijenti sa krvnim grupama O, A i B mogu se racunati istovremeno
	for (int i = 0; i < br_pacijenata; i++)
	{
		if (pacijenti[i].grupa == KRV_O)
		{
			bool rezultat = uzmi_krv(pacijenti[i], KRV_O, zalihe);
			if (rezultat == true)
				continue;
			
			nemoguce = true;
			break;
		}
		else if ((pacijenti[i].grupa == KRV_A) || (pacijenti[i].grupa == KRV_B))
		{
			bool rezultat = uzmi_krv(pacijenti[i], pacijenti[i].grupa, zalihe);
			if (rezultat == true)
				continue;

			rezultat = uzmi_krv(pacijenti[i], KRV_O, zalihe);
			if (rezultat == true)
				continue;

			nemoguce = true;
			break;
		}

	}

	//Pacijenti sa krvnom grupom AB ostavljeni su za kraj
	if(!nemoguce)
		for (int i = 0; i < br_pacijenata; i++)
		{
			if (pacijenti[i].grupa == KRV_AB)
			{
				bool rezultat = uzmi_krv(pacijenti[i], KRV_AB, zalihe);
				if (rezultat == true)
					continue;

				rezultat = uzmi_krv(pacijenti[i], KRV_A, zalihe);
				if (rezultat == true)
					continue;

				rezultat = uzmi_krv(pacijenti[i], KRV_B, zalihe);
				if (rezultat == true)
					continue;

				rezultat = uzmi_krv(pacijenti[i], KRV_O, zalihe);
				if (rezultat == true)
					continue;

				nemoguce = true;
				break;
			}
		}

	if (nemoguce)
	{
		printf("nemoguce");
	}
	else
	{
		printf("moguce\n");
		for (int i = 0; i < br_pacijenata; i++)
			printf("%d %d %d %d\n", pacijenti[i].izvor_krvi[KRV_O], pacijenti[i].izvor_krvi[KRV_A], pacijenti[i].izvor_krvi[KRV_B], pacijenti[i].izvor_krvi[KRV_AB]);
	}
	return 0;
}